/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY.                         *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.  Contact information: bergmark@cs.cornell.edu     *
 ******************************************************************************/

package cnrg.itx.datax;

/**
 * Inteface to abstract a destination. Any device that wants to behave like
 * a destination for the channel has to implement this interface.
 */
public interface Destination extends Statistics, Properties
{
	/**
	 * Method to implement the writing to the destination.
	 * @param data the byte array to be written to the destination
	 * @exception DataException thrown if the write method fails
	 */
	public void write (byte[] data) throws DataException;
	
	/**
	 * Method to mute the destination device.
	 * @param mode true if the destination has to be muted, false otherwise
	 * @return boolean true if mute succeeds, false otherwise
	 */
	public boolean mute (boolean mode);
	
	/**
	 * Method to close the destination device.
	 */
	public void close() ;
}